import {
  useField,
  useForm
} from "/build/_shared/chunk-76ASRIKV.js";
import {
  ActiveDatesCard,
  CombinationCard,
  CurrencyCode,
  DiscountClass,
  DiscountMethod,
  DiscountStatus,
  MethodCard,
  RequirementType,
  SummaryCard,
  UsageLimitsCard,
  onBreadcrumbAction,
  require_actions,
  require_app_bridge_react
} from "/build/_shared/chunk-N5DSUWFB.js";
import {
  require_shopify
} from "/build/_shared/chunk-SU66BP3D.js";
import {
  require_node
} from "/build/_shared/chunk-G7CHZRZX.js";
import {
  Form,
  useActionData,
  useLoaderData,
  useNavigation,
  useSubmit
} from "/build/_shared/chunk-JA4VWRSL.js";
import {
  Banner,
  Card,
  EmptyState,
  Layout,
  Page,
  PageActions,
  Text,
  TextField,
  VerticalStack
} from "/build/_shared/chunk-7ULSSQR5.js";
import "/build/_shared/chunk-GIAAE3CH.js";
import {
  require_jsx_dev_runtime
} from "/build/_shared/chunk-XU7DNSPJ.js";
import {
  createHotContext
} from "/build/_shared/chunk-26POGGSR.js";
import "/build/_shared/chunk-UWV35TSL.js";
import {
  require_react
} from "/build/_shared/chunk-BOXFZXVX.js";
import {
  __toESM
} from "/build/_shared/chunk-PNG5AS42.js";

// app/routes/app.volume-discount.$functionId.$id.jsx
var import_react = __toESM(require_react());
var import_node = __toESM(require_node());
var import_app_bridge_react = __toESM(require_app_bridge_react());
var import_actions = __toESM(require_actions());
var import_shopify = __toESM(require_shopify());

// app/components/NotFoundPage/empty-state.svg
var empty_state_default = "/build/_assets/empty-state-J7PKHSDM.svg";

// app/components/NotFoundPage/NotFoundPage.jsx
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime());
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app/components/NotFoundPage/NotFoundPage.jsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app/components/NotFoundPage/NotFoundPage.jsx"
  );
  import.meta.hot.lastModified = "1692612803108.5146";
}
function NotFoundPage() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Page, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Card, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(EmptyState, { heading: "There is no page at this address", image: empty_state_default, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { children: "Check the URL and try again, or use the search bar to find what you need." }, void 0, false, {
    fileName: "app/components/NotFoundPage/NotFoundPage.jsx",
    lineNumber: 27,
    columnNumber: 11
  }, this) }, void 0, false, {
    fileName: "app/components/NotFoundPage/NotFoundPage.jsx",
    lineNumber: 26,
    columnNumber: 9
  }, this) }, void 0, false, {
    fileName: "app/components/NotFoundPage/NotFoundPage.jsx",
    lineNumber: 25,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/NotFoundPage/NotFoundPage.jsx",
    lineNumber: 24,
    columnNumber: 10
  }, this);
}
_c = NotFoundPage;
var _c;
$RefreshReg$(_c, "NotFoundPage");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/NotFoundPage/index.js
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app/components/NotFoundPage/index.js"
  );
  import.meta.hot.lastModified = "1692612803116.515";
}

// app/routes/app.volume-discount.$functionId.$id.jsx
var import_jsx_dev_runtime2 = __toESM(require_jsx_dev_runtime());
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app/routes/app.volume-discount.$functionId.$id.jsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app/routes/app.volume-discount.$functionId.$id.jsx"
  );
  import.meta.hot.lastModified = "1692765107511.1035";
}
function VolumeEdit() {
  _s();
  const submitForm = useSubmit();
  const actionData = useActionData();
  const {
    discount
  } = useLoaderData();
  const navigation = useNavigation();
  const app = (0, import_app_bridge_react.useAppBridge)();
  const isLoading = navigation.state === "submitting";
  const currencyCode = CurrencyCode.Cad;
  const submitErrors = (actionData == null ? void 0 : actionData.errors) || [];
  const redirect = import_actions.Redirect.create(app);
  (0, import_react.useEffect)(() => {
    if ((actionData == null ? void 0 : actionData.errors.length) === 0) {
      redirect.dispatch(import_actions.Redirect.Action.ADMIN_SECTION, {
        name: import_actions.Redirect.ResourceType.Discount
      });
    }
  }, [actionData]);
  if (!discount) {
    return /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(NotFoundPage, {}, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
      lineNumber: 257,
      columnNumber: 12
    }, this);
  }
  const {
    metafieldId
  } = discount.configuration;
  const {
    fields: {
      discountTitle,
      discountCode,
      discountMethod,
      combinesWith,
      requirementType,
      requirementSubtotal,
      requirementQuantity,
      usageLimit,
      appliesOncePerCustomer,
      startDate,
      endDate,
      configuration
    },
    submit
  } = useForm({
    fields: {
      discountTitle: useField(discount.title),
      discountMethod: useField(discount.method),
      discountCode: useField(discount.code),
      combinesWith: useField(discount.combinesWith),
      requirementType: useField(RequirementType.None),
      requirementSubtotal: useField("0"),
      requirementQuantity: useField("0"),
      usageLimit: useField(discount.usageLimit),
      appliesOncePerCustomer: useField(discount.appliesOncePerCustomer),
      startDate: useField(discount.startsAt),
      endDate: useField(discount.endsAt),
      configuration: {
        quantity: useField(discount.configuration.quantity),
        percentage: useField(discount.configuration.percentage),
        orderAmount: useField(discount.configuration.orderAmount)
      }
    },
    onSubmit: async (form) => {
      const discount2 = {
        title: form.discountTitle,
        method: form.discountMethod,
        code: form.discountCode,
        combinesWith: form.combinesWith,
        usageLimit: form.usageLimit == null ? null : parseInt(form.usageLimit),
        appliesOncePerCustomer: form.appliesOncePerCustomer,
        startsAt: form.startDate,
        endsAt: form.endDate,
        configuration: {
          metafieldId,
          quantity: parseInt(form.configuration.quantity),
          percentage: parseFloat(form.configuration.percentage),
          orderAmount: parseFloat(form.configuration.orderAmount)
        }
      };
      submitForm({
        discount: JSON.stringify(discount2)
      }, {
        method: "post"
      });
      return {
        status: "success"
      };
    }
  });
  const errorBanner = submitErrors.length > 0 ? /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Banner, { status: "critical", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("p", { children: "There were some issues with your form submission:" }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
      lineNumber: 326,
      columnNumber: 11
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("ul", { children: submitErrors.map(({
      message,
      field
    }, index) => {
      return /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("li", { children: [
        field.join("."),
        " ",
        message
      ] }, `${message}${index}`, true, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 332,
        columnNumber: 18
      }, this);
    }) }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
      lineNumber: 327,
      columnNumber: 11
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
    lineNumber: 325,
    columnNumber: 9
  }, this) }, void 0, false, {
    fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
    lineNumber: 324,
    columnNumber: 49
  }, this) : null;
  return (
    // Render a discount form using Polaris components and the discount app components
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Page, { title: "Create volume discount", backAction: {
      content: "Discounts",
      onAction: () => onBreadcrumbAction(redirect, true)
    }, primaryAction: {
      content: "Save",
      onAction: submit,
      loading: isLoading
    }, children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Layout, { children: [
      errorBanner,
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Form, { method: "post", children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(VerticalStack, { align: "space-around", gap: "2", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(MethodCard, { title: "Volume", discountTitle, discountClass: DiscountClass.Product, discountCode, discountMethod }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 354,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Card, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(VerticalStack, { gap: "3", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Text, { variant: "headingMd", as: "h2", children: "Volume" }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
            lineNumber: 357,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(TextField, { label: "Minimum quantity", autoComplete: "on", ...configuration.quantity }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
            lineNumber: 360,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(TextField, { label: "Discount percentage", autoComplete: "on", ...configuration.percentage, suffix: "%" }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
            lineNumber: 361,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(TextField, { label: "Discount Apply when order amount more than", autoComplete: "on", ...configuration.orderAmount }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
            lineNumber: 362,
            columnNumber: 22
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 356,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 355,
          columnNumber: 15
        }, this),
        discountMethod.value === DiscountMethod.Code && /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(UsageLimitsCard, { totalUsageLimit: usageLimit, oncePerCustomer: appliesOncePerCustomer }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 365,
          columnNumber: 64
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(CombinationCard, { combinableDiscountTypes: combinesWith, discountClass: DiscountClass.Product, discountDescriptor: "Discount" }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 366,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(ActiveDatesCard, { startDate, endDate, timezoneAbbreviation: "EST" }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
          lineNumber: 367,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 353,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 352,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 351,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Layout.Section, { secondary: true, children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(SummaryCard, { header: {
        discountMethod: discountMethod.value,
        discountDescriptor: discountMethod.value === DiscountMethod.Automatic ? discountTitle.value : discountCode.value,
        appDiscountType: "Volume",
        isEditing: false
      }, performance: {
        status: DiscountStatus.Scheduled,
        usageCount: 0,
        isEditing: false
      }, minimumRequirements: {
        requirementType: requirementType.value,
        subtotal: requirementSubtotal.value,
        quantity: requirementQuantity.value,
        currencyCode
      }, usageLimits: {
        oncePerCustomer: appliesOncePerCustomer.value,
        totalUsageLimit: usageLimit.value
      }, activeDates: {
        startDate: startDate.value,
        endDate: endDate.value
      } }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 372,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 371,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(PageActions, { primaryAction: {
        content: "Save discount",
        onAction: submit,
        loading: isLoading
      }, secondaryActions: [{
        content: "Discard",
        onAction: () => onBreadcrumbAction(redirect, true)
      }] }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 395,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
        lineNumber: 394,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
      lineNumber: 349,
      columnNumber: 7
    }, this) }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.$id.jsx",
      lineNumber: 341,
      columnNumber: 5
    }, this)
  );
}
_s(VolumeEdit, "jszsxlpAqWQIbBdgKmLNNwub60M=", false, function() {
  return [useSubmit, useActionData, useLoaderData, useNavigation, import_app_bridge_react.useAppBridge, useForm, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField];
});
_c2 = VolumeEdit;
var _c2;
$RefreshReg$(_c2, "VolumeEdit");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;
export {
  VolumeEdit as default
};
//# sourceMappingURL=/build/routes/app.volume-discount.$functionId.$id-LA36IYQF.js.map
