/**
 * A plugin that adds an esast compiler: a small wrapper around `astring` to add
 * support for serializing JSX.
 *
 * @type {import('unified').Plugin<[RecmaStringifyOptions]|[], Program, string>}
 */
export function recmaStringify(
  options?: RecmaStringifyOptions | undefined
): void
export type Node = import('estree-jsx').Node
export type Program = import('estree-jsx').Program
export type JSXAttribute = import('estree-jsx').JSXAttribute
export type JSXClosingElement = import('estree-jsx').JSXClosingElement
export type JSXClosingFragment = import('estree-jsx').JSXClosingFragment
export type JSXElement = import('estree-jsx').JSXElement
export type JSXEmptyExpression = import('estree-jsx').JSXEmptyExpression
export type JSXExpressionContainer = import('estree-jsx').JSXExpressionContainer
export type JSXFragment = import('estree-jsx').JSXFragment
export type JSXIdentifier = import('estree-jsx').JSXIdentifier
export type JSXMemberExpression = import('estree-jsx').JSXMemberExpression
export type JSXNamespacedName = import('estree-jsx').JSXNamespacedName
export type JSXOpeningElement = import('estree-jsx').JSXOpeningElement
export type JSXOpeningFragment = import('estree-jsx').JSXOpeningFragment
export type JSXSpreadAttribute = import('estree-jsx').JSXSpreadAttribute
export type JSXText = import('estree-jsx').JSXText
export type VFile = import('vfile').VFile
export type SourceMapGenerator = typeof import('source-map').SourceMapGenerator
export type State = Omit<import('astring').State, 'write'> & {
  write: (code: string, node?: import('estree-jsx').Node | undefined) => void
}
export type Generator = {
  Identifier: (node: Node, state: State) => void
  Literal: (node: Node, state: State) => void
  Program: (node: Node, state: State) => void
  FunctionDeclaration: (node: Node, state: State) => void
  FunctionExpression: (node: Node, state: State) => void
  ArrowFunctionExpression: (node: Node, state: State) => void
  SwitchCase: (node: Node, state: State) => void
  CatchClause: (node: Node, state: State) => void
  VariableDeclarator: (node: Node, state: State) => void
  ExpressionStatement: (node: Node, state: State) => void
  BlockStatement: (node: Node, state: State) => void
  EmptyStatement: (node: Node, state: State) => void
  DebuggerStatement: (node: Node, state: State) => void
  WithStatement: (node: Node, state: State) => void
  ReturnStatement: (node: Node, state: State) => void
  LabeledStatement: (node: Node, state: State) => void
  BreakStatement: (node: Node, state: State) => void
  ContinueStatement: (node: Node, state: State) => void
  IfStatement: (node: Node, state: State) => void
  SwitchStatement: (node: Node, state: State) => void
  ThrowStatement: (node: Node, state: State) => void
  TryStatement: (node: Node, state: State) => void
  WhileStatement: (node: Node, state: State) => void
  DoWhileStatement: (node: Node, state: State) => void
  ForStatement: (node: Node, state: State) => void
  ForInStatement: (node: Node, state: State) => void
  ForOfStatement: (node: Node, state: State) => void
  VariableDeclaration: (node: Node, state: State) => void
  ClassDeclaration: (node: Node, state: State) => void
  ThisExpression: (node: Node, state: State) => void
  ArrayExpression: (node: Node, state: State) => void
  ObjectExpression: (node: Node, state: State) => void
  YieldExpression: (node: Node, state: State) => void
  UnaryExpression: (node: Node, state: State) => void
  UpdateExpression: (node: Node, state: State) => void
  BinaryExpression: (node: Node, state: State) => void
  AssignmentExpression: (node: Node, state: State) => void
  LogicalExpression: (node: Node, state: State) => void
  MemberExpression: (node: Node, state: State) => void
  ConditionalExpression: (node: Node, state: State) => void
  CallExpression: (node: Node, state: State) => void
  NewExpression: (node: Node, state: State) => void
  SequenceExpression: (node: Node, state: State) => void
  TemplateLiteral: (node: Node, state: State) => void
  TaggedTemplateExpression: (node: Node, state: State) => void
  ClassExpression: (node: Node, state: State) => void
  MetaProperty: (node: Node, state: State) => void
  AwaitExpression: (node: Node, state: State) => void
  ImportExpression: (node: Node, state: State) => void
  ChainExpression: (node: Node, state: State) => void
  PrivateIdentifier: (node: Node, state: State) => void
  Property: (node: Node, state: State) => void
  PropertyDefinition: (node: Node, state: State) => void
  Super: (node: Node, state: State) => void
  TemplateElement: (node: Node, state: State) => void
  SpreadElement: (node: Node, state: State) => void
  ObjectPattern: (node: Node, state: State) => void
  ArrayPattern: (node: Node, state: State) => void
  RestElement: (node: Node, state: State) => void
  AssignmentPattern: (node: Node, state: State) => void
  ClassBody: (node: Node, state: State) => void
  MethodDefinition: (node: Node, state: State) => void
  ImportDeclaration: (node: Node, state: State) => void
  ExportNamedDeclaration: (node: Node, state: State) => void
  ExportDefaultDeclaration: (node: Node, state: State) => void
  ExportAllDeclaration: (node: Node, state: State) => void
  ImportSpecifier: (node: Node, state: State) => void
  ImportDefaultSpecifier: (node: Node, state: State) => void
  ImportNamespaceSpecifier: (node: Node, state: State) => void
  ExportSpecifier: (node: Node, state: State) => void
  JSXIdentifier: (node: Node, state: State) => void
  JSXNamespacedName: (node: Node, state: State) => void
  JSXMemberExpression: (node: Node, state: State) => void
  JSXEmptyExpression: (node: Node, state: State) => void
  JSXExpressionContainer: (node: Node, state: State) => void
  JSXSpreadAttribute: (node: Node, state: State) => void
  JSXAttribute: (node: Node, state: State) => void
  JSXOpeningElement: (node: Node, state: State) => void
  JSXOpeningFragment: (node: Node, state: State) => void
  JSXClosingElement: (node: Node, state: State) => void
  JSXClosingFragment: (node: Node, state: State) => void
  JSXElement: (node: Node, state: State) => void
  JSXFragment: (node: Node, state: State) => void
  JSXText: (node: Node, state: State) => void
}
export type RecmaStringifyOptions = {
  /**
   * Generate a source map by passing a `SourceMapGenerator` from `source-map` in
   */
  SourceMapGenerator?:
    | typeof import('source-map').SourceMapGenerator
    | undefined
}
