import { N as Nullable, A as Arrayable } from './types-e6d31da0.js';
import './types.d-1e7e3fdf.js';

declare const isWindows: boolean;
declare function slash(str: string): string;
declare const VALID_ID_PREFIX = "/@id/";
declare function normalizeRequestId(id: string, base?: string): string;
declare const queryRE: RegExp;
declare const hashRE: RegExp;
declare const cleanUrl: (url: string) => string;
declare const isInternalRequest: (id: string) => boolean;
declare function normalizeModuleId(id: string): string;
declare function isPrimitive(v: any): boolean;
declare function toFilePath(id: string, root: string): {
    path: string;
    exists: boolean;
};
/**
 * Convert `Arrayable<T>` to `Array<T>`
 *
 * @category Array
 */
declare function toArray<T>(array?: Nullable<Arrayable<T>>): Array<T>;

export { VALID_ID_PREFIX, cleanUrl, hashRE, isInternalRequest, isPrimitive, isWindows, normalizeModuleId, normalizeRequestId, queryRE, slash, toArray, toFilePath };
