"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdbmsSessionStorageMigrator = void 0;
var tslib_1 = require("tslib");
var abstract_migration_engine_1 = require("./abstract-migration-engine");
var types_1 = require("./types");
var RdbmsSessionStorageMigrator = /** @class */ (function (_super) {
    tslib_1.__extends(RdbmsSessionStorageMigrator, _super);
    function RdbmsSessionStorageMigrator(dbConnection, opts, migrations) {
        if (opts === void 0) { opts = {}; }
        return _super.call(this, dbConnection, tslib_1.__assign(tslib_1.__assign({}, types_1.defaultRdbmsSessionStorageMigratorOptions), opts), migrations) || this;
    }
    RdbmsSessionStorageMigrator.prototype.hasMigrationBeenApplied = function (migrationName) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var query, rows;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        query = "\n      SELECT * FROM ".concat(this.options.migrationDBIdentifier, "\n      WHERE ").concat(this.getOptions().migrationNameColumnName, " = \n        ").concat(this.connection.getArgumentPlaceholder(1), ";\n    ");
                        return [4 /*yield*/, this.connection.query(query, [migrationName])];
                    case 2:
                        rows = _a.sent();
                        return [2 /*return*/, rows.length === 1];
                }
            });
        });
    };
    RdbmsSessionStorageMigrator.prototype.saveAppliedMigration = function (migrationName) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var insert;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        insert = "\n          INSERT INTO ".concat(this.options.migrationDBIdentifier, " (").concat(this.getOptions().migrationNameColumnName, ")\n          VALUES(").concat(this.connection.getArgumentPlaceholder(1), ");\n        ");
                        return [4 /*yield*/, this.connection.query(insert, [migrationName])];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    RdbmsSessionStorageMigrator.prototype.getOptions = function () {
        return this.options;
    };
    return RdbmsSessionStorageMigrator;
}(abstract_migration_engine_1.AbstractMigrationEngine));
exports.RdbmsSessionStorageMigrator = RdbmsSessionStorageMigrator;
//# sourceMappingURL=rdbms-session-storage-migrator.js.map