'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Defines the strategy to be used to store sessions for the Shopify App.
 */

/**
 * define the option required to instantiate an RDBMS session storage implementation
 */

/**
 * Define a common way for migrator to execute query on the underlying persistence layer
 */

/**
 * This is for the use cases of the RDBMS database where
 */

/**
 * Each migration 'migration_name' will be define the following way.
 * Via a function that receive the engine in parameter.
 */

/**
 * Defines what is needed for a migration to be execute
 */
class MigrationOperation {
  constructor(migrationName, migrationFunction) {
    /** Name of the migration that will be used to uniquely identity it among all other migration */
    this.migrationName = void 0;
    /** The actual migration function that will modify the perisitence storage */
    this.migrationFunction = void 0;
    this.migrationName = migrationName;
    this.migrationFunction = migrationFunction;
  }
}

/**
 * Defines how database migration will be handled.
 */

/**
 * Use to initialise session storage migrators
 */

const defaultSessionStorageMigratorOptions = {
  migrationDBIdentifier: 'shopify_sessions_migrations'
};
const defaultRdbmsSessionStorageMigratorOptions = {
  migrationDBIdentifier: 'shopify_sessions_migrations',
  migrationNameColumnName: 'migration_name'
};

exports.MigrationOperation = MigrationOperation;
exports.defaultRdbmsSessionStorageMigratorOptions = defaultRdbmsSessionStorageMigratorOptions;
exports.defaultSessionStorageMigratorOptions = defaultSessionStorageMigratorOptions;
