"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerWebhooksFactory = void 0;
var tslib_1 = require("tslib");
function registerWebhooksFactory(_a) {
    var api = _a.api, logger = _a.logger;
    return function registerWebhooks(_a) {
        var session = _a.session;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_b) {
                return [2 /*return*/, api.webhooks.register({ session: session }).then(function (response) {
                        Object.entries(response).forEach(function (_a) {
                            var _b = tslib_1.__read(_a, 2), topic = _b[0], topicResults = _b[1];
                            topicResults.forEach(function (_a) {
                                var success = _a.success, rest = tslib_1.__rest(_a, ["success"]);
                                if (success) {
                                    logger.debug('Registered webhook', {
                                        topic: topic,
                                        shop: session.shop,
                                        operation: rest.operation,
                                    });
                                }
                                else {
                                    logger.error('Failed to register webhook', {
                                        topic: topic,
                                        shop: session.shop,
                                        result: JSON.stringify(rest.result),
                                    });
                                }
                            });
                        });
                        return response;
                    })];
            });
        });
    };
}
exports.registerWebhooksFactory = registerWebhooksFactory;
//# sourceMappingURL=register.js.map