"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateWebhookFactory = void 0;
var tslib_1 = require("tslib");
function authenticateWebhookFactory(_a) {
    var api = _a.api, config = _a.config, logger = _a.logger;
    return function authenticate(request) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var rawBody, check, sessionId, session, webhookContext, restClient, graphqlClient;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (request.method !== 'POST') {
                            logger.debug('Received a non-POST request for a webhook. Only POST requests are allowed.', { url: request.url, method: request.method });
                            throw new Response(undefined, {
                                status: 405,
                                statusText: 'Method not allowed',
                            });
                        }
                        return [4 /*yield*/, request.text()];
                    case 1:
                        rawBody = _a.sent();
                        return [4 /*yield*/, api.webhooks.validate({
                                rawBody: rawBody,
                                rawRequest: request,
                            })];
                    case 2:
                        check = _a.sent();
                        if (!check.valid) {
                            logger.debug('Webhook validation failed', check);
                            throw new Response(undefined, { status: 400, statusText: 'Bad Request' });
                        }
                        sessionId = api.session.getOfflineId(check.domain);
                        return [4 /*yield*/, config.sessionStorage.loadSession(sessionId)];
                    case 3:
                        session = _a.sent();
                        webhookContext = {
                            apiVersion: check.apiVersion,
                            shop: check.domain,
                            topic: check.topic,
                            webhookId: check.webhookId,
                            payload: JSON.parse(rawBody),
                            session: undefined,
                            admin: undefined,
                        };
                        if (!session) {
                            return [2 /*return*/, webhookContext];
                        }
                        restClient = new api.clients.Rest({
                            session: session,
                            apiVersion: check.apiVersion,
                        });
                        graphqlClient = new api.clients.Graphql({
                            session: session,
                            apiVersion: check.apiVersion,
                        });
                        Object.entries(api.rest).forEach(function (_a) {
                            var _b = tslib_1.__read(_a, 2), name = _b[0], resource = _b[1];
                            Reflect.set(restClient, name, resource);
                        });
                        return [2 /*return*/, tslib_1.__assign(tslib_1.__assign({}, webhookContext), { session: session, admin: {
                                    rest: restClient,
                                    graphql: graphqlClient,
                                } })];
                }
            });
        });
    };
}
exports.authenticateWebhookFactory = authenticateWebhookFactory;
//# sourceMappingURL=authenticate.js.map