"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticatePublicFactory = void 0;
var tslib_1 = require("tslib");
var helpers_1 = require("../helpers");
function authenticatePublicFactory(params) {
    return function authenticatePublic(request) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var logger, sessionTokenHeader;
            var _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        logger = params.logger;
                        (0, helpers_1.rejectBotRequest)(params, request);
                        (0, helpers_1.respondToOptionsRequest)(params, request);
                        sessionTokenHeader = (0, helpers_1.getSessionTokenHeader)(request);
                        logger.info('Authenticating public request');
                        if (!sessionTokenHeader) {
                            logger.debug('Request did not contain a session token');
                            throw new Response(undefined, {
                                status: 401,
                                statusText: 'Unauthorized',
                            });
                        }
                        _a = {};
                        return [4 /*yield*/, (0, helpers_1.validateSessionToken)(params, sessionTokenHeader)];
                    case 1: return [2 /*return*/, (_a.sessionToken = _b.sent(),
                            _a.cors = (0, helpers_1.ensureCORSHeadersFactory)(params, request),
                            _a)];
                }
            });
        });
    };
}
exports.authenticatePublicFactory = authenticatePublicFactory;
//# sourceMappingURL=authenticate.js.map