"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSessionToken = void 0;
var tslib_1 = require("tslib");
function validateSessionToken(_a, token) {
    var api = _a.api, logger = _a.logger;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var payload, error_1;
        return tslib_1.__generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    logger.debug('Validating session token');
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, api.session.decodeSessionToken(token)];
                case 2:
                    payload = _b.sent();
                    logger.debug('Session token is valid', {
                        payload: JSON.stringify(payload),
                    });
                    return [2 /*return*/, payload];
                case 3:
                    error_1 = _b.sent();
                    logger.debug("Failed to validate session token: ".concat(error_1.message));
                    throw new Response(undefined, {
                        status: 401,
                        statusText: 'Unauthorized',
                    });
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.validateSessionToken = validateSessionToken;
//# sourceMappingURL=validate-session-token.js.map