"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.respondToOptionsRequest = void 0;
var ensure_cors_headers_1 = require("./ensure-cors-headers");
function respondToOptionsRequest(params, request) {
    if (request.method === 'OPTIONS') {
        var ensureCORSHeaders = (0, ensure_cors_headers_1.ensureCORSHeadersFactory)(params, request);
        throw ensureCORSHeaders(new Response(null, {
            status: 204,
            headers: {
                'Access-Control-Max-Age': '7200',
            },
        }));
    }
}
exports.respondToOptionsRequest = respondToOptionsRequest;
//# sourceMappingURL=respond-to-options-request.js.map