"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rejectBotRequest = void 0;
var tslib_1 = require("tslib");
var isbot_1 = tslib_1.__importDefault(require("isbot"));
function rejectBotRequest(_a, request) {
    var logger = _a.logger;
    if ((0, isbot_1.default)(request.headers.get('User-Agent'))) {
        logger.debug('Request is from a bot, skipping auth');
        throw new Response(undefined, { status: 410, statusText: 'Gone' });
    }
}
exports.rejectBotRequest = rejectBotRequest;
//# sourceMappingURL=reject-bot-request.js.map