"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectWithExitIframe = void 0;
var server_runtime_1 = require("@remix-run/server-runtime");
function redirectWithExitIframe(params, request, shop) {
    var api = params.api, config = params.config;
    var url = new URL(request.url);
    var queryParams = url.searchParams;
    var host = api.utils.sanitizeHost(queryParams.get('host'));
    queryParams.set('shop', shop);
    queryParams.set('exitIframe', "".concat(config.auth.path, "?shop=").concat(shop));
    if (host) {
        queryParams.set('host', host);
    }
    throw (0, server_runtime_1.redirect)("".concat(config.auth.exitIframePath, "?").concat(queryParams.toString()));
}
exports.redirectWithExitIframe = redirectWithExitIframe;
//# sourceMappingURL=redirect-with-exitiframe.js.map