"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addDocumentResponseHeaders = exports.addDocumentResponseHeadersFactory = void 0;
function addDocumentResponseHeadersFactory(params) {
    var api = params.api, config = params.config;
    return function (request, headers) {
        var searchParams = new URL(request.url).searchParams;
        var shop = api.utils.sanitizeShop(searchParams.get('shop'));
        addDocumentResponseHeaders(headers, config.isEmbeddedApp, shop);
    };
}
exports.addDocumentResponseHeadersFactory = addDocumentResponseHeadersFactory;
function addDocumentResponseHeaders(headers, isEmbeddedApp, shop) {
    if (shop) {
        headers.set('Link', '<https://cdn.shopify.com/shopifycloud/app-bridge.js>; rel="preload"; as="script";');
    }
    if (isEmbeddedApp) {
        if (shop) {
            headers.set('Content-Security-Policy', "frame-ancestors https://".concat(shop, " https://admin.shopify.com https://*.spin.dev;"));
        }
    }
    else {
        headers.set('Content-Security-Policy', "frame-ancestors 'none';");
    }
}
exports.addDocumentResponseHeaders = addDocumentResponseHeaders;
//# sourceMappingURL=add-response-headers.js.map