"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.restResourceClientFactory = exports.RemixRestClient = void 0;
var tslib_1 = require("tslib");
var helpers_1 = require("../helpers");
var RemixRestClient = /** @class */ (function () {
    function RemixRestClient(_a) {
        var params = _a.params, request = _a.request, session = _a.session;
        this.params = params;
        this.request = request;
        this.session = session;
    }
    /**
     * Performs a GET request on the given path.
     */
    RemixRestClient.prototype.get = function (params) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.makeRequest(tslib_1.__assign({ method: 'GET' }, params))];
            });
        });
    };
    /**
     * Performs a POST request on the given path.
     */
    RemixRestClient.prototype.post = function (params) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.makeRequest(tslib_1.__assign({ method: 'POST' }, params))];
            });
        });
    };
    /**
     * Performs a PUT request on the given path.
     */
    RemixRestClient.prototype.put = function (params) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.makeRequest(tslib_1.__assign({ method: 'PUT' }, params))];
            });
        });
    };
    /**
     * Performs a DELETE request on the given path.
     */
    RemixRestClient.prototype.delete = function (params) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.makeRequest(tslib_1.__assign({ method: 'DELETE' }, params))];
            });
        });
    };
    RemixRestClient.prototype.makeRequest = function (params) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var originalClient, originalRequest, apiResponse, error_1;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        originalClient = new this.params.api.clients.Rest({
                            session: this.session,
                        });
                        originalRequest = Reflect.get(originalClient, 'request');
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 5]);
                        return [4 /*yield*/, originalRequest.call(originalClient, params)];
                    case 2:
                        apiResponse = _a.sent();
                        // We use a separate client for REST requests and REST resources because we want to override the API library
                        // client class to return a Response object instead.
                        return [2 /*return*/, new Response(JSON.stringify(apiResponse.body), {
                                headers: apiResponse.headers,
                            })];
                    case 3:
                        error_1 = _a.sent();
                        return [4 /*yield*/, (0, helpers_1.handleClientError)({
                                params: this.params,
                                request: this.request,
                                shop: this.session.shop,
                                error: error_1,
                            })];
                    case 4: throw _a.sent();
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    return RemixRestClient;
}());
exports.RemixRestClient = RemixRestClient;
function restResourceClientFactory(_a) {
    var params = _a.params, request = _a.request, session = _a.session;
    var api = params.api, config = params.config, logger = params.logger;
    var ApiClient = api.clients.Rest;
    return /** @class */ (function (_super) {
        tslib_1.__extends(RestResourceClient, _super);
        function RestResourceClient() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RestResourceClient.prototype.request = function (params) {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var originalClient, originalRequest, error_2;
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            originalClient = new api.clients.Rest({ session: session });
                            originalRequest = Reflect.get(originalClient, 'request');
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 5]);
                            return [4 /*yield*/, originalRequest.call(originalClient, params)];
                        case 2: 
                        // We just call through to the API library client, and handle the error response here, so that data parsing
                        // behaves the same way.
                        return [2 /*return*/, _a.sent()];
                        case 3:
                            error_2 = _a.sent();
                            return [4 /*yield*/, (0, helpers_1.handleClientError)({
                                    params: { api: api, config: config, logger: logger },
                                    request: request,
                                    shop: session.shop,
                                    error: error_2,
                                })];
                        case 4: throw _a.sent();
                        case 5: return [2 /*return*/];
                    }
                });
            });
        };
        return RestResourceClient;
    }(ApiClient));
}
exports.restResourceClientFactory = restResourceClientFactory;
//# sourceMappingURL=rest-client.js.map