import { DeleteRequestParams, GetRequestParams, PostRequestParams, PutRequestParams, RequestParams, Session, Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import type { BasicParams } from '../../types';
interface RestClientOptions {
    params: BasicParams;
    request: Request;
    session: Session;
}
export declare class RemixRestClient<Resources extends ShopifyRestResources> {
    session: Session;
    resources: Resources;
    private params;
    private request;
    constructor({ params, request, session }: RestClientOptions);
    /**
     * Performs a GET request on the given path.
     */
    get(params: GetRequestParams): Promise<Response>;
    /**
     * Performs a POST request on the given path.
     */
    post(params: PostRequestParams): Promise<Response>;
    /**
     * Performs a PUT request on the given path.
     */
    put(params: PutRequestParams): Promise<Response>;
    /**
     * Performs a DELETE request on the given path.
     */
    delete(params: DeleteRequestParams): Promise<Response>;
    protected makeRequest(params: RequestParams): Promise<Response>;
}
export declare function restResourceClientFactory({ params, request, session, }: RestClientOptions): Shopify['clients']['Rest'];
export {};
//# sourceMappingURL=rest-client.d.ts.map