"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.graphqlClientFactory = void 0;
var tslib_1 = require("tslib");
var runtime_1 = require("@shopify/shopify-api/runtime");
var handle_client_error_1 = require("../helpers/handle-client-error");
// eslint-disable-next-line no-warning-comments
// TODO: This is actually just a call through to the Shopify API client, but with a different API. We should eventually
// move this over to the library layer. While doing that, we should also allow the apiVersion to be passed into the REST
// client request calls.
function graphqlClientFactory(_a) {
    var params = _a.params, request = _a.request, session = _a.session;
    return function query(query, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var api, config, logger, client, apiResponse, error_1;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        api = params.api, config = params.config, logger = params.logger;
                        client = new api.clients.Graphql({
                            session: session,
                            apiVersion: options === null || options === void 0 ? void 0 : options.apiVersion,
                        });
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 5]);
                        return [4 /*yield*/, client.query({
                                data: { query: query, variables: options === null || options === void 0 ? void 0 : options.variables },
                                tries: options === null || options === void 0 ? void 0 : options.tries,
                                extraHeaders: options === null || options === void 0 ? void 0 : options.headers,
                            })];
                    case 2:
                        apiResponse = _a.sent();
                        return [2 /*return*/, new Response(JSON.stringify(apiResponse.body), {
                                headers: (0, runtime_1.flatHeaders)(apiResponse.headers),
                            })];
                    case 3:
                        error_1 = _a.sent();
                        return [4 /*yield*/, (0, handle_client_error_1.handleClientError)({
                                params: { api: api, config: config, logger: logger },
                                request: request,
                                error: error_1,
                                shop: session.shop,
                            })];
                    case 4: throw _a.sent();
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
}
exports.graphqlClientFactory = graphqlClientFactory;
//# sourceMappingURL=graphql-client.js.map