'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var semver = require('semver');
var shopifyApi = require('@shopify/shopify-api');
var version = require('./version.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var semver__default = /*#__PURE__*/_interopDefaultLegacy(semver);

// eslint-disable-next-line no-warning-comments
// TODO This has been copied from shopify-app-express, it should be extracted into a shared package
// https://github.com/orgs/Shopify/projects/6899/views/1?pane=issue&itemId=28358070
function overrideLogger(logger) {
  const baseContext = {
    package: 'shopify-app'
  };
  const warningFunction = (message, context = {}) => logger.warning(message, {
    ...baseContext,
    ...context
  });
  function deprecated(warningFunction) {
    return function (version$1, message) {
      if (semver__default["default"].gte(version.SHOPIFY_REMIX_LIBRARY_VERSION, version$1)) {
        throw new shopifyApi.FeatureDeprecatedError(`Feature was deprecated in version ${version$1}`);
      }
      return warningFunction(`[Deprecated | ${version$1}] ${message}`);
    };
  }
  return {
    ...logger,
    log: (severity, message, context = {}) => logger.log(severity, message, {
      ...baseContext,
      ...context
    }),
    debug: (message, context = {}) => logger.debug(message, {
      ...baseContext,
      ...context
    }),
    info: (message, context = {}) => logger.info(message, {
      ...baseContext,
      ...context
    }),
    warning: warningFunction,
    error: (message, context = {}) => logger.error(message, {
      ...baseContext,
      ...context
    }),
    deprecated: deprecated(warningFunction)
  };
}

exports.overrideLogger = overrideLogger;
