'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var shopifyApi = require('@shopify/shopify-api');
var redirectToAuthPage = require('../auth/helpers/redirect-to-auth-page.js');
require('@remix-run/server-runtime');
require('isbot');

function cancelBillingFactory(params, request, session) {
  return async function cancelBilling(options) {
    const {
      api,
      logger
    } = params;
    logger.debug('Cancelling billing', {
      shop: session.shop,
      ...options
    });
    try {
      return await api.billing.cancel({
        session,
        subscriptionId: options.subscriptionId,
        isTest: options.isTest,
        prorate: options.prorate
      });
    } catch (error) {
      if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
        logger.debug('API token was invalid, redirecting to OAuth', {
          shop: session.shop
        });
        throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
  };
}

exports.cancelBillingFactory = cancelBillingFactory;
