'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('@remix-run/server-runtime');
var ensureCorsHeaders = require('../helpers/ensure-cors-headers.js');
var validateSessionToken = require('../helpers/validate-session-token.js');
var getSessionTokenHeader = require('../helpers/get-session-token-header.js');
var rejectBotRequest = require('../helpers/reject-bot-request.js');
var respondToOptionsRequest = require('../helpers/respond-to-options-request.js');
require('@shopify/shopify-api');

function authenticatePublicFactory(params) {
  return async function authenticatePublic(request) {
    const {
      logger
    } = params;
    rejectBotRequest.rejectBotRequest(params, request);
    respondToOptionsRequest.respondToOptionsRequest(params, request);
    const sessionTokenHeader = getSessionTokenHeader.getSessionTokenHeader(request);
    logger.info('Authenticating public request');
    if (!sessionTokenHeader) {
      logger.debug('Request did not contain a session token');
      throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized'
      });
    }
    return {
      sessionToken: await validateSessionToken.validateSessionToken(params, sessionTokenHeader),
      cors: ensureCorsHeaders.ensureCORSHeadersFactory(params, request)
    };
  };
}

exports.authenticatePublicFactory = authenticatePublicFactory;
