'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var serverRuntime = require('@remix-run/server-runtime');
var types = require('../../types.js');

function loginFactory(params) {
  const {
    api,
    config,
    logger
  } = params;
  return async function login(request) {
    const url = new URL(request.url);
    const shopParam = url.searchParams.get('shop');
    if (request.method === 'GET' && !shopParam) {
      return {};
    }
    const shop = shopParam || (await request.formData()).get('shop');
    if (!shop) {
      logger.debug('Missing shop parameter', {
        shop
      });
      return {
        shop: types.LoginErrorType.MissingShop
      };
    }
    const shopWithoutProtocol = shop.replace(/^https?:\/\//, '');
    const shopWithDomain = (shop === null || shop === void 0 ? void 0 : shop.indexOf('.')) === -1 ? `${shopWithoutProtocol}.myshopify.com` : shopWithoutProtocol;
    const sanitizedShop = api.utils.sanitizeShop(shopWithDomain);
    if (!sanitizedShop) {
      logger.debug('Invalid shop parameter', {
        shop
      });
      return {
        shop: types.LoginErrorType.InvalidShop
      };
    }
    const redirectUrl = `${config.appUrl}${config.auth.path}?shop=${sanitizedShop}`;
    logger.info(`Redirecting login request to ${redirectUrl}`, {
      shop: sanitizedShop
    });
    throw serverRuntime.redirect(redirectUrl);
  };
}

exports.loginFactory = loginFactory;
