'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var ensureCorsHeaders = require('./ensure-cors-headers.js');

function respondToOptionsRequest(params, request) {
  if (request.method === 'OPTIONS') {
    const ensureCORSHeaders = ensureCorsHeaders.ensureCORSHeadersFactory(params, request);
    throw ensureCORSHeaders(new Response(null, {
      status: 204,
      headers: {
        'Access-Control-Max-Age': '7200'
      }
    }));
  }
}

exports.respondToOptionsRequest = respondToOptionsRequest;
