'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var _const = require('../const.js');

function redirectWithAppBridgeHeaders(params, shop) {
  const {
    config
  } = params;
  const redirectUri = `${config.appUrl}${config.auth.path}?shop=${shop}`;
  throw new Response(undefined, {
    status: 401,
    statusText: 'Unauthorized',
    headers: getAppBridgeHeaders(redirectUri)
  });
}
function getAppBridgeHeaders(url) {
  return new Headers({
    [_const.REAUTH_URL_HEADER]: url
  });
}

exports.getAppBridgeHeaders = getAppBridgeHeaders;
exports.redirectWithAppBridgeHeaders = redirectWithAppBridgeHeaders;
