'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var _const = require('../const.js');

function ensureCORSHeadersFactory(params, request) {
  const {
    logger,
    config
  } = params;
  return function ensureCORSHeaders(response) {
    const origin = request.headers.get('Origin');
    if (origin && origin !== config.appUrl) {
      logger.debug('Request comes from a different origin, adding CORS headers');
      response.headers.set('Access-Control-Allow-Origin', '*');
      response.headers.set('Access-Control-Allow-Headers', 'Authorization');
      response.headers.set('Access-Control-Expose-Headers', _const.REAUTH_URL_HEADER);
    }
    return response;
  };
}

exports.ensureCORSHeadersFactory = ensureCORSHeadersFactory;
