'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('@remix-run/server-runtime');
require('isbot');
var handleClientError = require('../helpers/handle-client-error.js');

class RemixRestClient {
  constructor({
    params,
    request,
    session
  }) {
    this.session = void 0;
    this.resources = void 0;
    this.params = void 0;
    this.request = void 0;
    this.params = params;
    this.request = request;
    this.session = session;
  }

  /**
   * Performs a GET request on the given path.
   */
  async get(params) {
    return this.makeRequest({
      method: 'GET',
      ...params
    });
  }

  /**
   * Performs a POST request on the given path.
   */
  async post(params) {
    return this.makeRequest({
      method: 'POST',
      ...params
    });
  }

  /**
   * Performs a PUT request on the given path.
   */
  async put(params) {
    return this.makeRequest({
      method: 'PUT',
      ...params
    });
  }

  /**
   * Performs a DELETE request on the given path.
   */
  async delete(params) {
    return this.makeRequest({
      method: 'DELETE',
      ...params
    });
  }
  async makeRequest(params) {
    const originalClient = new this.params.api.clients.Rest({
      session: this.session
    });
    const originalRequest = Reflect.get(originalClient, 'request');
    try {
      const apiResponse = await originalRequest.call(originalClient, params);

      // We use a separate client for REST requests and REST resources because we want to override the API library
      // client class to return a Response object instead.
      return new Response(JSON.stringify(apiResponse.body), {
        headers: apiResponse.headers
      });
    } catch (error) {
      throw await handleClientError.handleClientError({
        params: this.params,
        request: this.request,
        shop: this.session.shop,
        error
      });
    }
  }
}
function restResourceClientFactory({
  params,
  request,
  session
}) {
  const {
    api,
    config,
    logger
  } = params;
  const ApiClient = api.clients.Rest;
  return class RestResourceClient extends ApiClient {
    async request(params) {
      const originalClient = new api.clients.Rest({
        session
      });
      const originalRequest = Reflect.get(originalClient, 'request');
      try {
        // We just call through to the API library client, and handle the error response here, so that data parsing
        // behaves the same way.
        return await originalRequest.call(originalClient, params);
      } catch (error) {
        throw await handleClientError.handleClientError({
          params: {
            api,
            config,
            logger
          },
          request,
          shop: session.shop,
          error
        });
      }
    }
  };
}

exports.RemixRestClient = RemixRestClient;
exports.restResourceClientFactory = restResourceClientFactory;
