'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var runtime = require('@shopify/shopify-api/runtime');
var handleClientError = require('../helpers/handle-client-error.js');

// eslint-disable-next-line no-warning-comments
// TODO: This is actually just a call through to the Shopify API client, but with a different API. We should eventually
// move this over to the library layer. While doing that, we should also allow the apiVersion to be passed into the REST
// client request calls.
function graphqlClientFactory({
  params,
  request,
  session
}) {
  return async function query(query, options) {
    var _options;
    const {
      api,
      config,
      logger
    } = params;
    const client = new api.clients.Graphql({
      session,
      apiVersion: (_options = options) === null || _options === void 0 ? void 0 : _options.apiVersion
    });
    try {
      var _options2, _options3, _options4;
      // We convert the incoming response to a Response object to bring this client closer to the Remix client.
      const apiResponse = await client.query({
        data: {
          query,
          variables: (_options2 = options) === null || _options2 === void 0 ? void 0 : _options2.variables
        },
        tries: (_options3 = options) === null || _options3 === void 0 ? void 0 : _options3.tries,
        extraHeaders: (_options4 = options) === null || _options4 === void 0 ? void 0 : _options4.headers
      });
      return new Response(JSON.stringify(apiResponse.body), {
        headers: runtime.flatHeaders(apiResponse.headers)
      });
    } catch (error) {
      throw await handleClientError.handleClientError({
        params: {
          api,
          config,
          logger
        },
        request,
        error,
        shop: session.shop
      });
    }
  };
}

exports.graphqlClientFactory = graphqlClientFactory;
