'use strict';

var crypto = require('crypto');
var runtime = require('@shopify/shopify-api/runtime');
var appBridgeUrl = require('../../auth/helpers/app-bridge-url.js');
require('@remix-run/server-runtime');
require('isbot');
require('@shopify/shopify-api');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var crypto__default = /*#__PURE__*/_interopDefaultLegacy(crypto);

runtime.setCrypto(crypto__default["default"]);
runtime.setAbstractRuntimeString(() => {
  return `Remix (Node)`;
});

/* eslint-disable no-process-env */
if (process.env.APP_BRIDGE_URL) {
  appBridgeUrl.setAppBridgeUrlOverride(process.env.APP_BRIDGE_URL);
}
/* eslint-enable no-process-env */
