import React from 'react';
import type { PseudotranslateOptions } from '@shopify/i18n';
import type { TranslationDictionary, ComplexReplacementDictionary, PrimitiveReplacementDictionary } from '../types';
export declare function memoizedNumberFormatter(locales?: string | string[], options?: Intl.NumberFormatOptions): Intl.NumberFormat;
export declare const PSEUDOTRANSLATE_OPTIONS: PseudotranslateOptions;
export interface TranslateOptions<Replacements = {}> {
    scope?: string | string[];
    replacements?: Replacements;
    pseudotranslate?: boolean | string;
    interpolate?: RegExp;
}
export declare function numberFormatCacheKey(locales?: string | string[], options?: Intl.NumberFormatOptions): string;
declare function pluralRules(locale: string, options?: Intl.PluralRulesOptions): Intl.PluralRules;
export declare const memoizedPluralRules: typeof pluralRules;
export declare function getTranslationTree(id: string, translations: TranslationDictionary | TranslationDictionary[], locale: string, replacements?: PrimitiveReplacementDictionary | ComplexReplacementDictionary): string | TranslationDictionary;
export declare function translate(id: string, options: TranslateOptions<PrimitiveReplacementDictionary>, translations: TranslationDictionary | TranslationDictionary[], locale: string): string;
export declare function translate(id: string, options: TranslateOptions<ComplexReplacementDictionary>, translations: TranslationDictionary | TranslationDictionary[], locale: string): (string | React.ReactElement<any>)[];
export {};
//# sourceMappingURL=translate.d.ts.map