/// <reference types="react" />
import type { I18nDetails, PrimitiveReplacementDictionary, ComplexReplacementDictionary, TranslationDictionary } from './types';
import { LanguageDirection } from './types';
import type { Weekday } from './constants';
import { DateStyle, UnicodeCharacterSet } from './constants';
import type { TranslateOptions as RootTranslateOptions } from './utilities';
export interface NumberFormatOptions extends Intl.NumberFormatOptions {
    as?: 'number' | 'currency' | 'percent';
    precision?: number;
}
export interface CurrencyFormatOptions extends NumberFormatOptions {
    form?: 'auto' | 'short' | 'explicit' | 'none';
}
export interface TranslateOptions {
    scope: RootTranslateOptions<any>['scope'];
}
export declare class I18n {
    readonly translations: TranslationDictionary[];
    readonly locale: string;
    readonly pseudolocalize: boolean | string;
    readonly defaultCountry?: string;
    readonly defaultCurrency?: string;
    readonly defaultTimezone?: string;
    readonly defaultInterpolate?: RegExp;
    readonly onError: NonNullable<I18nDetails['onError']>;
    readonly loading: boolean;
    get language(): string;
    get region(): string | undefined;
    /**
     * @deprecated Use I18n#region instead.
     */
    get countryCode(): string | undefined;
    get languageDirection(): LanguageDirection;
    get isRtlLanguage(): boolean;
    get isLtrLanguage(): boolean;
    constructor(translations: TranslationDictionary[], { locale, currency, timezone, country, pseudolocalize, onError, loading, interpolate, }: I18nDetails & {
        loading?: boolean;
    });
    translate(id: string, options: TranslateOptions, replacements?: PrimitiveReplacementDictionary): string;
    translate(id: string, options: TranslateOptions, replacements?: ComplexReplacementDictionary): React.ReactElement<any>;
    translate(id: string, replacements?: PrimitiveReplacementDictionary): string;
    translate(id: string, replacements?: ComplexReplacementDictionary): React.ReactElement<any>;
    getTranslationTree(id: string, replacements?: PrimitiveReplacementDictionary | ComplexReplacementDictionary): string | TranslationDictionary;
    translationKeyExists(id: string): boolean;
    formatNumber(amount: number, { as, precision, ...options }?: NumberFormatOptions): string;
    unformatNumber(input: string): string;
    formatCurrency(amount: number, { form, ...options }?: CurrencyFormatOptions): string;
    unformatCurrency(input: string, currencyCode: string): string;
    formatPercentage(amount: number, options?: Intl.NumberFormatOptions): string;
    formatDate(date: Date, options?: Intl.DateTimeFormatOptions & {
        style?: DateStyle;
    }): string;
    ordinal(amount: number): string;
    weekStartDay(argCountry?: I18n['defaultCountry']): Weekday;
    getCurrencySymbol: (currencyCode?: string, locale?: string) => {
        symbol: any;
        prefixed: boolean;
    };
    /**
     * @deprecated Replace usage of `i18n.getCurrencySymbolLocalized(locale, currency)` with `i18n.getCurrencySymbol(currency, locale)`
     */
    getCurrencySymbolLocalized(locale: string, currency: string): {
        symbol: any;
        prefixed: boolean;
    };
    formatName(firstName?: string, lastName?: string, options?: {
        full?: boolean;
    }): string;
    abbreviateName({ firstName, lastName, idealMaxLength, }: {
        firstName?: string;
        lastName?: string;
        idealMaxLength?: number;
    }): string;
    identifyScript(text: string): UnicodeCharacterSet[];
    hasEasternNameOrderFormatter(): boolean;
    numberSymbols: () => {
        thousandSymbol: any;
        decimalSymbol: any;
    };
    private formatCurrencyAuto;
    private formatCurrencyExplicit;
    private formatCurrencyShort;
    private formatCurrencyNone;
    private getShortCurrencySymbol;
    private humanizeDate;
    private formatDateTime;
    private humanizePastDate;
    private humanizeFutureDate;
    private getTimeZone;
    private getDateFromDate;
    private getTimeFromDate;
    private getWeekdayFromDate;
    private getMonthDayFromDate;
    private normalizedNumber;
    private integerValue;
    private decimalValue;
    private isTranslateOptions;
    private defaultOnError;
}
//# sourceMappingURL=i18n.d.ts.map