import type { BabelFile } from '@babel/core';
import type { TemplateBuilder } from '@babel/template';
import type Types from '@babel/types';
import type { NodePath } from '@babel/traverse';
export declare const I18N_CALL_NAMES: string[];
export interface Options {
    mode?: 'with-dynamic-paths' | 'with-explicit-paths' | 'from-generated-index' | 'from-dictionary-index';
    defaultLocale?: string;
}
interface State {
    program: NodePath<Types.Program>;
    opts: Options;
}
export default function injectWithI18nArguments({ types: t, template, }: {
    types: typeof Types;
    template: TemplateBuilder<Types.ImportDeclaration | Types.ObjectExpression>;
}): {
    visitor: {
        Program(nodePath: NodePath<Types.Program>, state: State): void;
        ImportDeclaration(this: {
            file: BabelFile;
        }, nodePath: NodePath<Types.ImportDeclaration>, state: State): void;
    };
};
export {};
//# sourceMappingURL=index.d.ts.map