import { UnicodeCharacterSet } from '../constants/index.mjs';

const SUPPORTED_SCRIPTS = [UnicodeCharacterSet.Latin, UnicodeCharacterSet.Han, UnicodeCharacterSet.Hiragana, UnicodeCharacterSet.Katakana, UnicodeCharacterSet.Hangul, UnicodeCharacterSet.Thai];
function identifyScripts(text) {
  return SUPPORTED_SCRIPTS.filter(supportedScript => new RegExp(`${supportedScript}`).test(text));
}

export { identifyScripts };
