import { join } from 'path';
import fs from 'fs-extra';
import { findTranslationBuckets, toArrayString, getLocaleIds, DEFAULT_FALLBACK_LOCALE } from './shared.mjs';

function generateTranslationIndexes() {
  const fallbackLocale = DEFAULT_FALLBACK_LOCALE;
  const translationBuckets = findTranslationBuckets(process.cwd());
  Object.entries(translationBuckets).forEach(([translationsDir, translationFilePaths]) => {
    const localeIdArrayString = toArrayString(getLocaleIds({
      translationFilePaths,
      fallbackLocale
    }));
    fs.writeFile(join(translationsDir, 'index.js'), `/* This is generated and should not be checked-in*/\nexport default ${localeIdArrayString};`);
  });
}

export { generateTranslationIndexes };
