'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var index = require('../constants/index.js');
var translate = require('./translate.js');

function getCurrencySymbol(locale, options) {
  const currencyStringRaw = formatCurrency(0, locale, options);
  const controlChars = new RegExp(`${index.UnicodeCharacterSet.DirectionControl}*`, 'gu');
  const currencyString = currencyStringRaw.replace(controlChars, '');
  const matchResult = /\p{Nd}\p{Po}*\p{Nd}*/gu.exec(currencyString);

  if (!matchResult) {
    throw new Error(`Number input in locale ${locale} is currently not supported.`);
  }

  const formattedAmount = matchResult[0];
  const [currencyPrefix, currencySuffix] = currencyString.split(formattedAmount);
  const elements = {
    symbol: currencyPrefix || currencySuffix,
    prefixed: currencyPrefix !== ''
  };
  return elements;
}
function formatCurrency(amount, locale, options) {
  return translate.memoizedNumberFormatter(locale, {
    style: 'currency',
    ...options
  }).format(amount);
}

exports.formatCurrency = formatCurrency;
exports.getCurrencySymbol = getCurrencySymbol;
