'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var index = require('../constants/index.js');

const SUPPORTED_SCRIPTS = [index.UnicodeCharacterSet.Latin, index.UnicodeCharacterSet.Han, index.UnicodeCharacterSet.Hiragana, index.UnicodeCharacterSet.Katakana, index.UnicodeCharacterSet.Hangul, index.UnicodeCharacterSet.Thai];
function identifyScripts(text) {
  return SUPPORTED_SCRIPTS.filter(supportedScript => new RegExp(`${supportedScript}`).test(text));
}

exports.identifyScripts = identifyScripts;
