import { useRef } from 'react';
import { useIsomorphicLayoutEffect } from './isomorphic-layout-effect.mjs';

function useMountedRef() {
  const mounted = useRef(true);
  useIsomorphicLayoutEffect(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  return mounted;
}

export { useMountedRef };
