import { useRef, useEffect } from 'react';
import { useIsomorphicLayoutEffect } from './isomorphic-layout-effect.mjs';

// Adapted from https://overreacted.io/making-setinterval-declarative-with-react-hooks
// Also available at https://github.com/gaearon/overreacted.io/blob/master/src/pages/making-setinterval-declarative-with-react-hooks/index.md
//
// Copyright (c) 2020 Dan Abramov and the contributors.
//
function useInterval(callback, delay) {
  const savedCallback = useRef(callback); // Need to use a layout effect to force the saved callback to be synchronously updated during a commit

  useIsomorphicLayoutEffect(() => {
    savedCallback.current = callback;
  }, [callback]);
  useEffect(() => {
    function tick() {
      savedCallback.current();
    }

    if (delay !== null) {
      const id = setInterval(tick, delay);
      return () => clearInterval(id);
    }

    return undefined;
  }, [delay]);
}

export { useInterval };
