import { useRef, useEffect } from 'react';

function useDelayedCallback(callback, delay) {
  const timeoutRef = useRef();
  useEffect(() => {
    return () => {
      if (timeoutRef.current != null) {
        clearTimeout(timeoutRef.current);
      }
    };
  }, []);

  function callbackWithDelay() {
    const timeoutId = setTimeout(() => {
      callback();
      timeoutRef.current = undefined;
    }, delay);
    timeoutRef.current = timeoutId;
  }

  return callbackWithDelay;
}

export { useDelayedCallback };
