'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var isomorphicLayoutEffect = require('./isomorphic-layout-effect.js');

function useTimeout(callback, delay) {
  const savedCallback = React.useRef(callback); // Need to use a layout effect to force the saved callback to be synchronously updated during a commit

  isomorphicLayoutEffect.useIsomorphicLayoutEffect(() => {
    savedCallback.current = callback;
  }, [callback]);
  React.useEffect(() => {
    function tick() {
      savedCallback.current();
    }

    if (delay !== null) {
      const id = setTimeout(tick, delay);
      return () => clearTimeout(id);
    }

    return undefined;
  }, [delay]);
}

exports.useTimeout = useTimeout;
