'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

function createUseMediaFactory(useEffectHook) {
  return query => {
    const [match, setMatch] = React.useState(false);
    useEffectHook(() => {
      if (!window || !window.matchMedia) {
        return;
      }

      const matchMedia = window.matchMedia(query);

      const updateMatch = event => setMatch(event.matches);

      setMatch(matchMedia.matches);
      matchMedia.addListener(updateMatch);
      return () => {
        matchMedia.removeListener(updateMatch);
      };
    }, [query]);
    return match;
  };
}

const useMedia = createUseMediaFactory(React.useEffect);
const useMediaLayout = createUseMediaFactory(React.useLayoutEffect);

exports.useMedia = useMedia;
exports.useMediaLayout = useMediaLayout;
