'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var utilities = require('../../../utilities.js');
var reducer = require('../../field/reducer.js');

function reinitializeAction(list) {
  return {
    type: 'reinitialize',
    payload: {
      list
    }
  };
}
function addFieldItemAction(list) {
  return {
    type: 'addFieldItem',
    payload: {
      list
    }
  };
}
function editFieldItemAction(editedItem, index) {
  return {
    type: 'editFieldItem',
    payload: {
      editedItem,
      index
    }
  };
}
function moveFieldItemAction(fromIndex, toIndex) {
  return {
    type: 'moveFieldItem',
    payload: {
      fromIndex,
      toIndex
    }
  };
}
function removeFieldItemAction(indexToRemove) {
  return {
    type: 'removeFieldItem',
    payload: {
      indexToRemove
    }
  };
}
function removeFieldItemsAction(indicesToRemove) {
  return {
    type: 'removeFieldItems',
    payload: {
      indicesToRemove
    }
  };
}
function updateAction(payload) {
  return {
    type: 'update',
    payload
  };
}
function resetAction(payload) {
  return {
    type: 'reset',
    payload
  };
}
function resetListAction() {
  return {
    type: 'resetList'
  };
}
function newDefaultAction(payload) {
  return {
    type: 'newDefaultValue',
    payload
  };
}
function updateErrorAction(payload) {
  return {
    type: 'updateError',
    payload
  };
}
function useListReducer(initial) {
  return react.useReducer(reduceList, {
    list: initial.map(initialListItemState),
    initial
  });
}

function reduceList(state, action) {
  switch (action.type) {
    case 'reinitialize':
      {
        return {
          initial: action.payload.list,
          list: action.payload.list.map(initialListItemState)
        };
      }

    case 'moveFieldItem':
      {
        const {
          fromIndex,
          toIndex
        } = action.payload;

        if (fromIndex >= state.list.length || fromIndex < 0 || toIndex >= state.list.length || toIndex < 0) {
          throw new Error(`Failed to move item from ${fromIndex} to ${toIndex}`);
        }

        const newList = [...state.list];
        const [item] = newList.splice(action.payload.fromIndex, 1);
        newList.splice(action.payload.toIndex, 0, item);
        return { ...state,
          list: newList
        };
      }

    case 'addFieldItem':
      {
        return { ...state,
          list: [...state.list, ...action.payload.list.map(initialListItemState)]
        };
      }

    case 'editFieldItem':
      {
        var _state$list, _state$list$map;

        const {
          editedItem,
          index
        } = action.payload; // Don't do a full rewrite of the object, only edit data which is supplied.

        const list = state === null || state === void 0 ? void 0 : (_state$list = state.list) === null || _state$list === void 0 ? void 0 : (_state$list$map = _state$list.map) === null || _state$list$map === void 0 ? void 0 : _state$list$map.call(_state$list, (item, i) => i === index ? { ...item,
          ...editedItem
        } : item);
        return { ...state,
          list
        };
      }

    case 'removeFieldItem':
      {
        const newList = [...state.list];
        newList.splice(action.payload.indexToRemove, 1);
        return { ...state,
          list: newList
        };
      }

    case 'removeFieldItems':
      {
        var _action$payload$indic, _action$payload;

        const indicesToRemove = (_action$payload$indic = action === null || action === void 0 ? void 0 : (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.indicesToRemove) !== null && _action$payload$indic !== void 0 ? _action$payload$indic : [];
        const list = state.list.filter((_, i) => !indicesToRemove.includes(i));
        return { ...state,
          list
        };
      }

    case 'updateError':
      {
        const {
          payload: {
            target,
            error
          }
        } = action;
        const {
          index,
          key
        } = target;
        const currentItem = state.list[index];
        currentItem[key] = reducer.reduceField(currentItem[key], reducer.updateErrorAction(error));
        return { ...state,
          list: [...state.list]
        };
      }

    case 'reset':
      {
        const {
          payload: {
            target
          }
        } = action;
        const {
          index,
          key
        } = target;
        const currentItem = state.list[index];
        currentItem[key] = reducer.reduceField(currentItem[key], {
          type: 'reset'
        });
        return { ...state,
          list: [...state.list]
        };
      }

    case 'resetList':
      {
        return { ...state,
          list: state.initial.map(initialListItemState)
        };
      }

    case 'update':
    case 'newDefaultValue':
      {
        const {
          payload: {
            target,
            value
          }
        } = action;
        const {
          index,
          key
        } = target;
        const currentItem = state.list[index];
        currentItem[key] = reducer.reduceField(currentItem[key], {
          type: action.type,
          payload: value
        });
        return { ...state,
          list: [...state.list]
        };
      }
  }
}

function initialListItemState(item) {
  return utilities.mapObject(item, reducer.initialFieldState);
}

exports.addFieldItemAction = addFieldItemAction;
exports.editFieldItemAction = editFieldItemAction;
exports.moveFieldItemAction = moveFieldItemAction;
exports.newDefaultAction = newDefaultAction;
exports.reinitializeAction = reinitializeAction;
exports.removeFieldItemAction = removeFieldItemAction;
exports.removeFieldItemsAction = removeFieldItemsAction;
exports.resetAction = resetAction;
exports.resetListAction = resetListAction;
exports.updateAction = updateAction;
exports.updateErrorAction = updateErrorAction;
exports.useListReducer = useListReducer;
