'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class EffectManager {
  get finished() {
    return this.effects.length === 0;
  }

  constructor({
    include = true
  } = {}) {
    this.effects = [];
    this.kinds = new Set();
    this.include = include;
  }

  reset() {
    this.effects = [];
    this.kinds = new Set();
  }

  add(effect, kind) {
    if (kind != null) {
      this.kinds.add(kind);
    }

    if (effect == null || typeof effect !== 'object' || !('then' in effect)) {
      return;
    }

    this.effects.push(effect);
  }

  async resolve() {
    await Promise.all(this.effects);
  }

  async betweenEachPass(pass) {
    await Promise.all([...this.kinds].map(kind => typeof kind.betweenEachPass === 'function' ? kind.betweenEachPass(pass) : Promise.resolve()));
  }

  async afterEachPass(pass) {
    const results = await Promise.all([...this.kinds].map(kind => typeof kind.afterEachPass === 'function' ? kind.afterEachPass(pass) : Promise.resolve()));
    return results.every(result => result !== false);
  }

  shouldPerform(kind) {
    const {
      include
    } = this;

    if (!include) {
      return false;
    }

    return include === true || kind != null && include.includes(kind.id);
  }

}

exports.EffectManager = EffectManager;
