import React from 'react';
import { Item } from '../Item/Item.js';
import { Box } from '../../../Box/Box.js';

function List({
  focusIndex,
  disclosureTabs,
  onClick = noop,
  onKeyPress = noop
}) {
  const tabs = disclosureTabs.map(({
    id,
    content,
    ...tabProps
  }, index) => {
    return /*#__PURE__*/React.createElement(Item, Object.assign({
      key: id
    }, tabProps, {
      id: id,
      focused: index === focusIndex,
      onClick: onClick.bind(null, id)
    }), content);
  });
  return /*#__PURE__*/React.createElement("div", {
    onKeyDown: handleKeyDown,
    onKeyUp: onKeyPress
  }, /*#__PURE__*/React.createElement(Box, {
    as: "ul",
    padding: "2"
  }, tabs));
}
function noop() {}
function handleKeyDown(event) {
  const {
    key
  } = event;
  if (key === 'ArrowLeft' || key === 'ArrowRight') {
    event.preventDefault();
    event.stopPropagation();
  }
}

export { List };
