import React from 'react';
import { useBreakpoints } from '../../utilities/breakpoints.js';
import { WithinContentContext } from '../../utilities/within-content-context.js';
import { ShadowBevel } from '../ShadowBevel/ShadowBevel.js';
import { useFeatures } from '../../utilities/features/hooks.js';
import { Box } from '../Box/Box.js';

const Card = ({
  children,
  background = 'bg',
  padding = {
    xs: '4',
    sm: '5'
  },
  roundedAbove
}) => {
  const breakpoints = useBreakpoints();
  const {
    polarisSummerEditions2023
  } = useFeatures();
  const defaultBorderRadius = polarisSummerEditions2023 ? '3' : '2';
  const isDefaultPadding = typeof padding !== 'string' && padding?.xs === '4' && padding?.sm === '5' && padding.md === undefined && padding.lg === undefined && padding.xl === undefined;
  const finalPadding = isDefaultPadding && polarisSummerEditions2023 ? {
    xs: '4'
  } : padding;
  let hasBorderRadius = !roundedAbove;
  if (roundedAbove && breakpoints[`${roundedAbove}Up`]) {
    hasBorderRadius = true;
  }
  return /*#__PURE__*/React.createElement(WithinContentContext.Provider, {
    value: true
  }, polarisSummerEditions2023 ? /*#__PURE__*/React.createElement(ShadowBevel, {
    boxShadow: "xs",
    borderRadius: hasBorderRadius ? '3' : '0-experimental',
    zIndex: "32"
  }, /*#__PURE__*/React.createElement(Box, {
    background: background,
    padding: finalPadding,
    overflowX: "hidden",
    overflowY: "hidden",
    minHeight: "100%"
  }, children)) : /*#__PURE__*/React.createElement(Box, {
    background: background,
    padding: finalPadding,
    shadow: "md",
    borderRadius: hasBorderRadius ? defaultBorderRadius : undefined,
    overflowX: "hidden",
    overflowY: "hidden"
  }, children));
};

export { Card };
