import type { MetadataProperties, Experimental } from '../types';
type FontFamilyAlias = 'sans' | 'mono';
type FontSizeScaleExperimental = Experimental<'70' | '80'>;
export type FontSizeScale = '75' | '100' | '200' | '300' | '400' | '500' | '600' | '700' | FontSizeScaleExperimental;
type FontLineHeightScaleExperimental = Experimental<'075'>;
export type FontLineHeightScale = '1' | '2' | '3' | '4' | '5' | '6' | '7' | FontLineHeightScaleExperimental;
export type FontWeightAlias = 'regular' | 'medium' | 'semibold' | 'bold';
export type FontTokenName = `font-family-${FontFamilyAlias}` | `font-size-${FontSizeScale}` | `font-weight-${FontWeightAlias}` | `font-line-height-${FontLineHeightScale}`;
export type FontTokenGroup = {
    [TokenName in FontTokenName]: string;
};
export declare const font: {
    [TokenName in FontTokenName]: MetadataProperties;
};
export {};
//# sourceMappingURL=font.d.ts.map