import type { Experimental, MetadataProperties } from '../types';
type BorderRadiusScaleExperimental = Experimental<'0' | '1_5'>;
export type BorderRadiusScale = '05' | '1' | '2' | '3' | '4' | '5' | '6' | 'full' | BorderRadiusScaleExperimental;
type BorderWidthScaleExperimental = Experimental<'1' | '2'>;
export type BorderWidthScale = '1' | '2' | '3' | '4' | '5' | BorderWidthScaleExperimental;
export type BorderTokenName = `border-radius-${BorderRadiusScale}` | `border-width-${BorderWidthScale}`;
export type BorderTokenGroup = {
    [TokenName in BorderTokenName]: string;
};
export declare const border: {
    [TokenName in BorderTokenName]: MetadataProperties;
};
export {};
//# sourceMappingURL=border.d.ts.map