import { tokensToRems } from './utilities.mjs';
import { border } from './token-groups/border.mjs';
import { breakpoints } from './token-groups/breakpoints.mjs';
import { color } from './token-groups/color.mjs';
import { font } from './token-groups/font.mjs';
import { motion } from './token-groups/motion.mjs';
import { shadow } from './token-groups/shadow.mjs';
import { space } from './token-groups/space.mjs';
import { zIndex } from './token-groups/zIndex.mjs';

var metadata = createMetadata({
  breakpoints: tokensToRems(breakpoints),
  border: tokensToRems(border),
  color: color,
  font: tokensToRems(font),
  motion: motion,
  shadow: tokensToRems(shadow),
  space: tokensToRems(space),
  zIndex: zIndex
});
/**
 * Identity function that simply returns the provided tokens with metadata, but additionally
 * validates the input matches the `Metadata` type exactly and infers all members.
 */
function createMetadata(metadata) {
  return metadata;
}

export { createMetadata, metadata };
