import { Redirect } from '@shopify/app-bridge/actions';
import type { LinkAction } from '../types';
/**
 * Redirects to the Admin Discounts page if isAdmin is true, otherwise redirects to the app root or a specified fallbackPath within the app.
 */
export declare function onBreadcrumbAction(redirect: Redirect.Redirect, isAdmin: boolean, fallbackPath?: string): void;
/**
 * Convenience wrapper for AppBridge [Redirect](https://shopify.dev/apps/tools/app-bridge/actions/navigation/redirect#redirect-to-a-specific-resource-in-shopify-admin) actions
 */
export declare function handleRedirect({ redirect, ...props }: {
    redirect: Redirect.Redirect;
} & LinkAction): void;
