/// <reference types="lodash" />
import type { DateTime } from '../types';
export declare const getDateTimeInShopTimeZone: (date: DateTime, ianaTimezone: string) => Date;
export declare const getDateInShopTimeZone: (date: Date, ianaTimezone: string) => Date;
/**
 * Removes browser and shop timezone offset from a date.
 */
export declare const getDateInUTC: (date: Date, ianaTimezone: string) => Date;
/**
 * Given the shop timezone, returns a timezone offset in hours between the shop timezone and the browser timezone.
 *
 * @param ianaTimezone - Iana
 */
export declare const getBrowserAndShopTimeZoneOffset: ((ianaTimezone: string) => number) & import("lodash").MemoizedFunction;
/**
 * Given a date, returns a copy of the same date at the start of day.
 */
export declare const getNewDateAtStartOfDay: (date: Date) => Date;
/**
 * Given a date, returns a copy of the same date at the end of day.
 */
export declare const getNewDateAtEndOfDay: (date: Date) => Date;
