import React from 'react';
import { RecurringPaymentType } from '~/constants';
import type { Field, PositiveNumericString } from '~/types';
interface Props {
    /**
     * The recurring payment type (e.g. "All payments", "First payment", etc.)
     */
    recurringPaymentType: Field<RecurringPaymentType>;
    /**
     * The number of times the discount can be used for a recurring payment.
     */
    recurringPaymentLimit: Field<PositiveNumericString>;
}
export declare function RecurringPayment({ recurringPaymentType, recurringPaymentLimit, }: Props): React.JSX.Element;
export {};
