import React from 'react';
import type { PositiveNumericString } from '~/types';
export interface UsageLimitsProps {
    /**
     * The total number of times a discount can be used
     */
    totalUsageLimit: PositiveNumericString | null;
    /**
     * When true, a discount may only be used once per customer
     */
    oncePerCustomer: boolean;
}
export declare function UsageLimits({ totalUsageLimit, oncePerCustomer, }: UsageLimitsProps): React.JSX.Element;
