import React from 'react';
import { RecurringPaymentType } from '~/constants';
import type { PositiveNumericString } from '~/types';
export interface RecurringPaymentProps {
    /**
     * If a discount is applicable for recurring payments
     */
    isRecurring: boolean;
    /**
     * The type of recurring payments (e.g. first payment, multiple payments, all payments)
     */
    recurringPaymentType: RecurringPaymentType;
    /**
     * (optional) If the discount is available for RecurringPaymentType.MultiplePayments, this value displays how many payments the discount is available for
     */
    recurringPaymentLimit?: PositiveNumericString;
}
export declare function RecurringPayment({ isRecurring, recurringPaymentType, recurringPaymentLimit, }: RecurringPaymentProps): React.JSX.Element | null;
